# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import six

try:
    import pathlib
except ImportError:
    import pathlib2 as pathlib


from travel.library.python.dicts.buses.carrier_repository import CarrierRepository

import config
from util.lazy_setuper import LazySetuper


class CarrierProvider(LazySetuper):
    def __init__(self):
        super(CarrierProvider, self).__init__()
        self._carrier_repo = CarrierRepository()

    def _setup(self, carrier_repo=None):
        if carrier_repo is None:
            self._carrier_repo.load_from_file(six.text_type(pathlib.Path(config.RASP_DATA_PATH) / "carrier.bin"))
        else:
            self._carrier_repo = carrier_repo

    @LazySetuper.setup_required
    def get_by_id(self, id):
        return self._carrier_repo.get(id)


carrier_provider = CarrierProvider()
