# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import six
try:
    import pathlib
except ImportError:
    import pathlib2 as pathlib

from travel.library.python.dicts.buses.point_matching_repository import PointMatchingRepository

import config
from util.lazy_setuper import LazySetuper


class PointMatchingProvider(LazySetuper):
    def __init__(self):
        super(PointMatchingProvider, self).__init__()
        self._point_matching_index = {}

    def _setup(self, point_matching_repo=None):
        if point_matching_repo is None:
            point_matching_repo = PointMatchingRepository()
            point_matching_repo.load_from_file(six.text_type(pathlib.Path(config.RASP_DATA_PATH) / "point_matching.bin"))

        for point_matching in point_matching_repo.itervalues():
            self._point_matching_index[
                self._gen_key(point_matching.supplier_id, point_matching.supplier_point_id)
            ] = point_matching

    @staticmethod
    def _gen_key(supplier_id, supplier_point_id):
        return supplier_id, supplier_point_id

    @LazySetuper.setup_required
    def get(self, supplier_id, supplier_point_id):
        return self._point_matching_index.get(self._gen_key(supplier_id, supplier_point_id))

    @LazySetuper.setup_required
    def itervalues(self):
        return self._point_matching_index.itervalues()


point_matching_provider = PointMatchingProvider()
