# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import six
try:
    import pathlib
except ImportError:
    import pathlib2 as pathlib

from travel.library.python.dicts.buses.register_type_repository import RegisterTypeRepository

import config
from util.lazy_setuper import LazySetuper


class RegisterTypeProvider(LazySetuper):
    def __init__(self):
        super(RegisterTypeProvider, self).__init__()
        self._register_type_repo = RegisterTypeRepository()

    def _setup(self, register_type_repo=None):
        if register_type_repo is None:
            self._register_type_repo.load_from_file(six.text_type(pathlib.Path(config.RASP_DATA_PATH) / "register_type.bin"))
        else:
            self._register_type_repo = register_type_repo

    @LazySetuper.setup_required
    def get_by_id(self, id):
        return self._register_type_repo.get(id)


register_type_provider = RegisterTypeProvider()
