# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import six
try:
    import pathlib
except ImportError:
    import pathlib2 as pathlib

from travel.library.python.dicts.buses.supplier_repository import SupplierRepository

import config as config
from util.lazy_setuper import LazySetuper


class SupplierProvider(LazySetuper):
    def __init__(self):
        super(SupplierProvider, self).__init__()
        self._repo = SupplierRepository()
        self._repo_by_code = SupplierRepository(index_field="code")

    def _setup(self, supplier_repo=None):
        if supplier_repo is None:
            repo_path = six.text_type(pathlib.Path(config.RASP_DATA_PATH) / "supplier.bin")
            self._repo.load_from_file(repo_path)
        else:
            self._repo = supplier_repo
        for supplier in self._repo.itervalues():
            self._repo_by_code.add_object(supplier)

    @LazySetuper.setup_required
    def get_by_code(self, code):
        return self._repo_by_code.get(code)

    @LazySetuper.setup_required
    def get_by_id(self, id):
        return self._repo.get(id)


supplier_provider = SupplierProvider()
