# -*- coding: utf-8 -*-
from yabus.common.fields import Optional, Required
from yabus import common

from flask_restful import fields


class Book(common.Book):
    fields = {
        'firstName': Required(fields.String, types=basestring),
        'middleName': Required(fields.String, types=basestring),
        'lastName': Required(fields.String, types=basestring),
        'birthDate': Required(fields.String, types=basestring),
        'group': Required(fields.Integer(attribute='ticketTypeCode'), types=(int, long)),
        'gender': Required(fields.String(attribute='genderCode'), types=basestring),
        'citizenship': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'documenttype': Required(fields.Integer(attribute='docTypeCode'), types=(int, long)),
        'document': Required(fields.FormattedString('{docSeries} {docNumber}'), types=basestring),
        'seatnumber': Required(fields.String(attribute='seatCode'), types=basestring),
        'mobile': Optional(fields.String(attribute='phone'), types=basestring),
    }
