# -*- coding: utf-8 -*-
from flask_restful import fields

from yabus import common
from yabus.common import fields as cfields
from yabus.sks.entities.ticket import Ticket
from yabus.sks.identifiers import OrderID


class Order(common.Order):
    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    fields = {
        'partner': cfields.Constant('sks'),
        'partnerName': cfields.Constant('СКС'),
        '@id': OrderID(order_sid='id'),
        'supplierId': fields.String(attribute='id'),
        'status': Ticket.Status,
        'price': fields.Float(attribute='price.value'),
        'tickets': fields.List(Ticket),
    }

    @classmethod
    def format(cls, value):
        tickets = value['tickets']
        value['id'] = str(value['id'])
        if isinstance(tickets, list):
            for idx, ticket in enumerate(tickets):
                ticket['index'] = idx
                ticket['order_id'] = value['id']
        return super(Order, cls).format(value)
