# -*- coding: utf-8 -*-
from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class RideDetails(common.RideDetails):
    class DocumentType(common.RideDetails.OTBDocType):
        def format(self, value):
            return super(RideDetails.DocumentType, self).format(int(value))

    @cfields.converter
    class TicketType(common.RideDetails.TicketType):
        conv = {
            'adult': 1,
            'child': 2,
        }

    @cfields.converter
    class GenderType(common.RideDetails.GenderType):
        conv = {
            'M': 1,
            'W': 2,
        }

    class TicketCode(TicketType):
        def format(self, value):
            value = super(RideDetails.TicketCode, self).format(value)
            if value is None:
                return self.default
            return str(value['id'])

    _doc_types = [{'code': str(c), 'type': t} for c, t in common.RideDetails.OTBDocType.variants()]
    _gender_types = [{'code': str(c), 'type': t} for c, t in GenderType.variants()]
    _citizenships = [{'code': str(c), 'name': c} for c in common.citizenships]

    fields = {
        'docTypes': fields.Raw(attribute='__not_existent__', default=_doc_types),
        'ticketTypes': fields.List(fields.Nested({
            'code': TicketCode(attribute='type'),
            'type': TicketType,
            'price': fields.Float(attribute='value'),
        })),
        'genderTypes': fields.Raw(attribute='__not_existent__', default=_gender_types),
        'citizenships': fields.Raw(attribute='__not_existent__', default=_citizenships),
        'seats': fields.List(fields.Nested({
            'code': fields.String(attribute='number'),
            'number': fields.String,
        }), attribute='freeSeats'),
    }
