# -*- coding: utf-8 -*-
from yabus.sks.entities.ride_details import RideDetails
from yabus.sks.identifiers import TicketID
from yabus.common import fields as cfields
from yabus import common, util

from flask_restful import fields


class Ticket(common.Ticket):
    @cfields.id_wrapper(TicketID)
    class TicketID(cfields.Dict):
        def format(self, value):
            return util.encode_utf8(value)

    @cfields.converter
    class Status(common.Ticket.Status):
        # TODO (need additional info from sks)
        conv = {
            'PENDING': 1,
            'CONFIRMED': 7,
        }

    fields = {
        '@id': TicketID(ticket_sid='id', order_sid='order_id', idx='index'),
        'supplierId': fields.String(attribute='id'),
        'status': Status,
        'data': {
            'id': fields.String(attribute='id'),
            'code': fields.String(attribute='id'),
            'number': fields.String(attribute='id'),
            'series': fields.String(default='', attribute='__not_existent__'),
            'barcode': fields.String(attribute='__not_existent__'),
            'platform': fields.String(attribute='__not_existent__')
        },
        'price': fields.Float(attribute='price.value'),
        'passenger': fields.Nested({
            'birthDate': cfields.ISODate(dt_format='iso8601'),
            'genderType': RideDetails.GenderType(attribute='gender'),
            'docType': RideDetails.DocumentType(attribute='documenttype'),
            'docNumber': fields.String(attribute='document'),
        }),
    }

    @classmethod
    def format(cls, value):
        value['passenger']['ticketType'] = int(value['price']['type'])
        return super(Ticket, cls).format(value)

    @classmethod
    def output(cls, idx, obj):
        obj[idx]['id'] += u'-{}'.format(idx)
        seat = obj[idx]['seat']['number']
        if not seat.isdigit():
            seat = seat.split(',')[idx]
        obj[idx]['passenger']['seat'] = seat
        return super(Ticket, cls).output(idx, obj)
