# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import re

from yabus.common import exceptions
from yabus.util import dump_response

code_to_error = [
    (re.compile(r'Выберите более позднюю дату'), exceptions.InvalidRide),
    (re.compile(r'Место \d+ уже занято'), exceptions.PlaceAlreadyOccupied),
]


def parse_error(func):
    def wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except exceptions.PartnerError as e:
            message = e.message
            error_type = next((cls for r, cls in code_to_error if r.match(message)), exceptions.Error)
            raise error_type(message, context=dump_response(e.response))
    return wrapper
