# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import json

from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.common.exceptions import PartnerError
from yabus.sks import defaults


class Session(common.Session):
    def __init__(self, url=None, user_id=None, user_key=None, **kwargs):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.user_id = user_id or secrets['sks-login']
        self.user_key = user_key or secrets['sks-token']
        super(Session, self).__init__(url or defaults.URL, **kwargs)

    def request(self, method, path, **kwargs):
        params = kwargs.get('params', {})
        params.update({
            'userid':  self.user_id,
            'userkey': self.user_key,
        })
        kwargs['params'] = params
        if path[-1] != '/':
            path += '/'
        resp = super(Session, self).request(method, path, verify=False, **kwargs)
        return self._response(resp)

    @staticmethod
    def _strip_content(content):
        content = content.strip()
        l, r = content.find(b'{'), content.rfind(b'}')
        return content[l:r+1]

    @staticmethod
    def _response(response):
        content = Session._strip_content(response.content)
        if not content:
            return None
        data = json.loads(content)
        if Session._is_error(data):
            raise PartnerError(data['message'], response, data)
        return data

    @staticmethod
    def _is_error(data):
        return len(data) == 2 and all(x in data for x in ('code', 'message'))
