# -*- coding: utf-8 -*-
from yabus.util import formatting, modechooser
from yabus import etraffic, ruset


sources = {
    'etraffic': etraffic.SoapClient,
    'ruset': ruset.SoapClient,
}


def list_methods(args):
    client = sources[args.source](args.url, args.username, args.password)
    print args.format(list(client.itermethods()), args.pretty)


def show_type(args):
    client = sources[args.source](args.url, args.username, args.password)
    print args.format(client.factory.create(args.type), args.pretty)


def call(args):
    client = sources[args.source](args.url, args.username, args.password)
    print args.format(client.call(args.method, args.args), args.pretty)


def main():
    mc = modechooser.ModeChooser(description="sputnik/soapclient")
    mc.add_argument('--source', choices=sources.keys(), default=sources.keys()[0])
    mc.add_argument('--url')
    mc.add_argument('--username')
    mc.add_argument('--password')
    mc.add_argument('--format', action=formatting.Action,
        choices=formatting.__choices__, default=formatting.__choices__[0])
    mc.add_argument('--pretty', action='store_true')

    mc.add_mode('list-methods', list_methods, help="list api methods")

    show_type_mode = mc.add_mode('show-type', show_type, help="show type")
    show_type_mode.add_argument('type')

    call_mode = mc.add_mode('call', call, help="call api method")
    call_mode.add_argument('method')
    call_mode.add_argument('args', nargs='*', default=[])

    return mc.run()


if __name__ == '__main__':
    main()
