# -*- coding: utf-8 -*-
from flask_restful import fields

from yabus.common import fields as cfields
from yabus import common


from yabus.unitiki.defaults import SUPPLIER_CODE
from yabus.unitiki.entities.ticket import Ticket
from yabus.unitiki.identifiers import OrderID


class Order(common.Order):
    @cfields.id_wrapper(OrderID)
    class OrderID(cfields.Dict):
        pass

    @cfields.converter
    class OrderStatus(common.Ticket.Status):
        conv = {
            3: 1,
            2: 2,
            1: 7,
        }

    fields = {
        '@id': OrderID(order_sid='operation_id'),
        'supplierId': fields.String(attribute='operation_id'),
        'status': OrderStatus,
        'tickets': fields.List(Ticket, attribute='ticket_list'),
        'partner': cfields.Constant(SUPPLIER_CODE),
        'partnerName': cfields.Constant('Unitiki'),
    }

    @classmethod
    def format(cls, value):
        instance = super(Order, cls).format(value)
        instance['price'] = sum([x['price'] for x in instance['tickets']])
        return instance
