# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.common import exceptions
from yabus.util import dump_response

__all__ = [
    'parse_error',
]


code_to_ride_details_error = {
    1: exceptions.InvalidRide,  # Неверный ride_segment
}


code_to_book_error = {
    2: exceptions.InvalidPlace,  # Неверно выбраны места
    4: exceptions.InvalidCredentials,  # Неверны ID документа
    5: exceptions.InvalidCredentials,  # Неверный ID гражданства
    7: exceptions.PlaceAlreadyOccupied,  # Место уже продано
}


code_to_confirm_error = {
    1: exceptions.InvalidOrder,  # Неверный ID операции
    2: exceptions.Expired,  # Время брони истекло
}


code_to_refund_error = {
    1: exceptions.InvalidTicket,  # Неверный ID билета
    3: exceptions.InvalidOrder,  # Неверный ID операции
}


code_to_ticket_error = {
    1: exceptions.InvalidTicket,  # Неверный ID билета
}


method_to_table = {
    'ride_details': code_to_ride_details_error,
    'book': code_to_book_error,
    'confirm': code_to_confirm_error,
    'refund': code_to_refund_error,
    'ticket': code_to_ticket_error,
}


def parse_error(method):
    def decorator(func):
        def wrapper(*args, **kwargs):
            try:
                return func(*args, **kwargs)
            except exceptions.PartnerError as e:
                error_code = e.fault.get('error_code')
                error_type = method_to_table[method].get(error_code, exceptions.Error)
                error_message = e.fault.get('error_message', '<empty>')
                raise error_type(error_message, context=dump_response(e.response))
        return wrapper
    return decorator
