# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from hashlib import md5


class Params(dict):
    agent_id_key = 'agent_id'
    secret_key = 'secret_key'
    order = [
        'agent_id',
        'city_id_start',
        'city_id_end',
        'date',
        'show_similar',
        'partner_id',
        'search_id',
        'station_id_start',
        'station_id_end',
        'time',
        'ride_segment_id',
        'from_cache',
        'ticket_data',
        'user_id',
        'ticket_id',
        'operation_id',
        'secret_key',
    ]

    def __init__(self, data, agent_id, secret):
        copy = data.copy()
        copy[Params.agent_id_key] = agent_id
        super(Params, self).__init__(copy, hash=Params.hash(copy, secret))

    @staticmethod
    def hash(data, secret):
        copy = data.copy()
        copy[Params.secret_key] = secret
        return md5(Params.str(copy)).hexdigest()

    @staticmethod
    def str(data):
        def generator(data):
            for k in Params.order:
                if k in data:
                    yield '{}={}'.format(k, data[k])
        return ''.join(generator(data))
