# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import cgi

from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.common.exceptions import PartnerError
from yabus.unitiki import defaults
from yabus.unitiki.params import Params


def _has_json_content(response):
    content_type = response.headers.get('Content-Type', '')
    mimetype, _params = cgi.parse_header(content_type)
    return mimetype == 'application/json'


class Session(common.Session):
    def __init__(self, url=None, agent_id=None, secret=None, **kwargs):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.agent_id = agent_id or secrets['unitiki-login']
        self.secret = secret or secrets['unitiki-token']
        super(Session, self).__init__(url or defaults.URL, **kwargs)

    def request(self, method, path, raw_content=False, **kwargs):
        resp = super(Session, self).request(method, path, **kwargs)
        if raw_content:
            if _has_json_content(resp):
                self._raise_on_error(resp, resp.json())
            resp.raise_for_status()
            return resp.content
        return Session._response(resp)

    def get(self, path, params, **kwargs):
        if not isinstance(params, Params):
            params = Params(params, self.agent_id, self.secret)
        return super(Session, self).get(path, params=params or {}, **kwargs)

    def post(self, path, data, **kwargs):
        params = Params(data, self.agent_id, self.secret)
        for k in data.keys():
            del params[k]
        return super(Session, self).post(path, data=data, params=params, **kwargs)

    @staticmethod
    def _raise_on_error(response, response_data):
        error = response_data.get('error')
        if error and 400 <= error['code'] <= 500:
            raise PartnerError("{error_code}: {error_message}".format(**error), response, error)

    @classmethod
    def _response(cls, response):
        response_data = response.json()
        cls._raise_on_error(response, response_data)
        return response_data.get('data', {})
