# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

import logging
from datetime import timedelta

from gevent import sleep

from util.lazy_setuper import LazySetuper


logger = logging.getLogger(__name__)


class AutoUpdater(LazySetuper):
    def __init__(self, period=None):
        self._period = period or timedelta(minutes=15)
        super(AutoUpdater, self).__init__()

    def _setup(self):
        self._update()

    def _update(self):
        raise NotImplementedError

    def run_update_loop(self):
        while True:
            sleep(self._period.total_seconds())
            try:
                self._update()
            except Exception:
                logger.exception('{}: Failed a regular update.'.format(self.__class__.__name__))
