# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import enum
import functools

import gevent
import ratelimit


class BottleneckBehavior(enum.Enum):
    RAISE = 1
    SLEEP = 2
    RETURN_NONE = 3


def bottleneck(calls, period=1, behavior=BottleneckBehavior.SLEEP):
    limits = ratelimit.limits(
        calls=calls, period=period, raise_on_limit=(behavior is not BottleneckBehavior.RETURN_NONE)
    )

    def decorator(func):
        limits_wrapped = limits(func)

        @functools.wraps(func)
        def sleep_wrapped(*args, **kwargs):
            while True:
                try:
                    return limits_wrapped(*args, **kwargs)
                except ratelimit.RateLimitException as exception:
                    gevent.sleep(exception.period_remaining)

        wrapped = sleep_wrapped if behavior is BottleneckBehavior.SLEEP else limits_wrapped
        wrapped.bottleneck = limits
        return wrapped

    return decorator
