# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from cachetools.func import lru_cache


abc = set('.0123456789abcdefghijklmnopqrstuvwxyzабвгдежзийклмнопрстуфхцчшщъыьэюя')

stop_words = [
   'ип',
   'ооо',
   'общество с ограниченной ответственностью',
   'прочие',
   'нерезидент',
   'международные',
]


@lru_cache(maxsize=8192)
def normalize(name):
    name = name.lower().strip()
    for s in stop_words:
        if name.startswith(s + ' '):
            name = name[len(s) + 1:]
        if name.endswith(' ' + s):
            name = name[:-len(s) - 1]
    return ''.join(c for c in name.replace('ё', 'е') if c in abc)


__all__ = (
    'normalize',
)
