# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from enum import Enum


class RegisterType(Enum):
    OGRN = (1, 'ОГРН', 'Основной государственный регистрационный номер')
    OGRNIP = (2, 'ОГРНИП', 'Основной государственный регистрационный номер индивидуального предпринимателя')

    def __init__(self, id, code, title):
        self.id = id
        self.code = code
        self.title = title


def register_type_format(register_type):
    return {
        'id': register_type.id,
        'code': register_type.code,
        'title': register_type.title,
    }
