# -*- coding: utf-8 -*-
from Crypto.Cipher.AES import AESCipher
import base64
import json


class Cipher(AESCipher, object):
    AES_16 = 16
    AES_24 = 24
    AES_32 = 32

    def __init__(self, key):
        AESCipher.__init__(self, self._mkkey(key))

    def encrypt(self, data):
        data = json.dumps(data)
        data += '\0' * (16 - len(data) % 16)
        return super(Cipher, self).encrypt(data)

    def decrypt(self, data):
        data = super(Cipher, self).decrypt(data)
        return json.loads(data.rstrip('\0'))

    @staticmethod
    def _mkkey(key):
        key = key[:Cipher.AES_32]
        size = len(key)
        if size in (Cipher.AES_16, Cipher.AES_24, Cipher.AES_32):
            return key
        return key + '0' * (Cipher.AES_32 - size % Cipher.AES_32)


class B64Cipher(Cipher):
    def encrypt(self, data):
        data = super(B64Cipher, self).encrypt(data)
        return base64.b64encode(data)

    def decrypt(self, data):
        data = base64.b64decode(data)
        return super(B64Cipher, self).decrypt(data)
