# -*- coding: utf-8 -*-
from __future__ import absolute_import
import argparse
import inspect


class Action(argparse.Action):
    def __call__(self, parser, namespace, values, option_string=None):
        from yabus.util import formatting
        for name, obj in inspect.getmembers(formatting):
            if name == values:
                setattr(namespace, self.dest, obj)
                return
        raise ValueError("Unknown formatting type: `%r`" % values)
