# -*- coding: utf-8 -*-
import zeep

from datetime import date, datetime
import json


class Format(object):
    def __call__(self, sobject, pretty=False):
        raise NotImplementedError

    def __str__(self):
        return self.__class__.__name__.lower()

    def __repr__(self):
        return str(self)

    def __eq__(self, other):
        if isinstance(other, basestring):
            return str(self) == other.lower()
        return self == other


class Raw(Format):
    def __call__(self, sobject, pretty=False):
        return sobject


class Python(Format):
    def __call__(self, zobject, pretty=False):
        return Python.aspython(zobject)

    @staticmethod
    def aspython(zobject):
        if isinstance(zobject, zeep.xsd.valueobjects.CompoundValue):
            zobject = zobject.__values__
        if isinstance(zobject, dict):
            return Python.asdict(zobject)
        if isinstance(zobject, list):
            return Python.aslist(zobject)
        if isinstance(zobject, unicode):
            return unicode(zobject).encode('utf-8')
        return zobject

    @staticmethod
    def asdict(zdict):
        return {Python.aspython(k): Python.aspython(v) for k, v in zdict.items()}

    @staticmethod
    def aslist(zlist):
        return map(Python.aspython, zlist)


class Json(Python):
    class JSONEncoder(json.JSONEncoder):
        def __init__(self, **kwargs):
            kwargs['ensure_ascii'] = False
            super(Json.JSONEncoder, self).__init__(**kwargs)

        def default(self, o):
            if isinstance(o, (date, datetime)):
                return o.isoformat()
            return super(Json.JSONEncoder, self).default(o)

    def __call__(self, sobject, pretty=False):
        pobject = super(Json, self).__call__(sobject)
        return Json.JSONEncoder(indent=2 if pretty else None).encode(pobject)
