# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

import datetime

import six


def humanize_duration(duration):
    # type: (datetime.timedelta) -> six.text_type
    seconds = abs(int(duration.total_seconds()))
    minutes, _seconds = divmod(seconds, 60)
    hours, minutes = divmod(minutes, 60)
    parts = []
    if hours:
        parts.append("{} ч".format(hours))
    if minutes:
        parts.append("{} м".format(minutes))
    return " ".join(parts)
