# -*- coding: utf-8 -*-
from argparse import ArgumentParser


class ModeChooser(ArgumentParser):
    def __init__(self, **kwargs):
        super(ModeChooser, self).__init__(**kwargs)
        self.modes = self.add_subparsers(parser_class=ArgumentParser)

    def add_mode(self, name, handler, **kwargs):
        parser = self.modes.add_parser(name, **kwargs)
        parser.set_defaults(handler=handler)
        return parser

    def run(self):
        args = self.parse_args()
        return args.handler(args)
