# -*- coding: utf-8 -*-
from functools import wraps

from gevent import sleep


def retry(count, exceptions, cooldown=0):
    def decorator(func):
        @wraps(func)
        def wrapper(*args, **kwargs):
            for i in range(count):
                try:
                    return func(*args, **kwargs)
                except exceptions:
                    if i == count - 1:
                        raise
                    sleep(cooldown)
        return wrapper
    return decorator
