# -*- coding: utf-8 -*-
import time
from contextlib import contextmanager


class Timer:
    def __init__(self, start_time=None):
        self._start_time = start_time if start_time is not None else time.time()

    @property
    def delta(self):
        return (time.time() - self._start_time) * 1000


@contextmanager
def measure_time():
    yield Timer()
