# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from config import YUGAVTOTRANS_CARRIERS_UPDATE_PERIOD
from yabus.util.auto_updater import AutoUpdater
from yabus.yugavtotrans.session import Session


class YugavtotransCarrierProvider(AutoUpdater):
    def __init__(self, session=None):
        self._session = session or Session()

        self._cached = []
        self._by_id = {}
        super(YugavtotransCarrierProvider, self).__init__(period=YUGAVTOTRANS_CARRIERS_UPDATE_PERIOD)

    def _update(self):
        self._cached = self._session.get('carriers')
        self._by_id = {s['id']: s for s in self._cached}

    def get_by_id(self, id):
        assert self._setuped
        return self._by_id.get(id)


carrier_provider = YugavtotransCarrierProvider()
