# -*- coding: utf-8 -*-
from yabus.common.fields import Optional, Required
from yabus import common

from datetime import datetime
from flask_restful import fields


class Book(common.Book):
    class Date(fields.DateTime):
        def format(self, value):
            value = datetime.strptime(value[:10], '%Y-%m-%d')
            return value.strftime('%d.%m.%Y')

    fields = {
        'name': Required(fields.Raw(attribute='firstName'), types=basestring),
        'last_name': Required(fields.Raw(attribute='lastName'), types=basestring),
        'second_name': Required(fields.Raw(attribute='middleName'), types=basestring),
        'personal_gender': Required(fields.Raw(attribute='genderCode'), types=basestring),
        'personal_birthday': Required(Date(attribute='birthDate'), types=basestring),
        'document': Required(fields.String(attribute='docTypeCode'), types=basestring),
        'document_number': Required(fields.FormattedString('{docSeries} {docNumber}'), types=basestring),
        'citizenship': Required(fields.String(attribute='citizenshipCode'), types=basestring),
        'type_tickets': Required(fields.Integer(attribute='ticketTypeCode'), types=(int, long)),
        'phone': Optional(fields.String),
        'seat': Required(fields.Integer(attribute='seatCode'), types=(int, long)),
    }
