from yabus.common import fields as cfields
from yabus import common

from flask_restful import fields


class Endpoint(common.Endpoint):
    class Location(fields.Float):
        def __init__(self, pos, **kwargs):
            super(fields.Float, self).__init__(**kwargs)
            self._pos = pos

        def format(self, value):
            try:
                return float(value.split(',')[self._pos].strip())
            except ValueError:
                return self.default
            except LookupError:
                return self.default

    fields = {
        'supplier_id': fields.Raw(attribute='station_id'),
        'title': fields.String(attribute='station_name'),
        'description': fields.FormattedString('{city_name}, {landing_name}'),
        'latitude': Location(pos=0, attribute='landing_coordinates'),
        'longitude': Location(pos=1, attribute='landing_coordinates'),
        'type': cfields.Constant('station'),
        'city_id': fields.String(attribute='city_id'),
        'city_title': fields.String(attribute='city_name'),
    }
