# -*- coding: utf-8 -*-
from yabus.yugavtotrans.entities.ride import Ride
from yabus.yugavtotrans.entities.ride_details import RideDetails
from yabus.yugavtotrans.identifiers import TicketID
from yabus.common import fields as cfields
from yabus import common

from datetime import datetime
from flask_restful import fields


class Ticket(common.Ticket):
    @cfields.id_wrapper(TicketID)
    class TicketID(cfields.Dict):
        pass

    @cfields.converter
    class Status(common.Ticket.Status):
        conv = {
            'reservations': 1,
            'canceled': 2,
            'payed': 7,
        }

    class Date(fields.DateTime):
        def format(self, value):
            value = datetime.strptime(value, '%d.%m.%Y')
            return super(Ticket.Date, self).format(value)

    fields = {
        '@id': TicketID(ticket_sid='ticket_id'),
        'supplierId': fields.String(attribute='ticket_id'),
        'status': Status,
        'data': {
            'id': fields.String(attribute='ticket_id'),
            'code': fields.String(attribute='ticket_id'),
            'number': fields.String(attribute='ticket_id'),
            'series': fields.String(attribute='order_id'),
        },
        'price': Ride.Price,
        'passenger': {
            'birthDate': Date(dt_format='iso8601', attribute='personal_birthday'),
            'genderType': RideDetails.GenderType(attribute='personal_gender'),
            'citizenship': RideDetails.Country(attribute='citizenship_id'),
            'docType': RideDetails.DocumentType(attribute='passenger_document'),
            'docNumber': fields.String(attribute='document_number'),
            'ticketType': common.RideDetails.TicketType(attribute='type_tickets'),
            'seat': fields.String(attribute='place', default='0'),
        },
    }

    @classmethod
    def format(cls, value):
        for k, v in zip(['lastName', 'firstName', 'middleName'], value.pop('passenger_name').split()):
            value[k] = v
        return super(Ticket, cls).format(value)
