# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from yabus.common import exceptions
from yabus.util import dump_response


code_to_error = {
    19: exceptions.PlaceAlreadyOccupied,
    4: exceptions.InvalidCredentials,
    14: exceptions.Expired,
    11: exceptions.InvalidTicket,
    18: exceptions.AlreadyConfirmed,
}


default_errors = {
    'book': exceptions.BookingError,
    'confirm': exceptions.ConfirmError,
    'refund': exceptions.RefundError,
}


def parse_error(func):
    default_error = default_errors.get(func.__name__, exceptions.Error)

    def wrapper(*args, **kwargs):
        try:
            return func(*args, **kwargs)
        except exceptions.PartnerError as e:
            error_type = code_to_error.get(e.fault.get('code'), default_error)
            raise error_type(e.message, context=dump_response(e.response))
    return wrapper
