# coding: utf-8
from __future__ import absolute_import, division, print_function, unicode_literals

from travel.library.python.rasp_vault.api import get_secret

import config
from yabus import common
from yabus.common.exceptions import PartnerError
from yabus.yugavtotrans import defaults


class Session(common.Session):
    def __init__(self, url=None, key=None, **kwargs):
        secrets = get_secret(config.CONNECTOR_SECRET_NAME)
        self.key = key or secrets['yugavtotrans-token']
        super(Session, self).__init__(url or defaults.URL, **kwargs)

    def request(self, method, path, **kwargs):
        params = kwargs.get('params', {})
        params['key'] = self.key
        kwargs['params'] = params

        headers = kwargs.get('headers', {})
        headers['Content-Type'] = 'application/json'
        kwargs['headers'] = headers

        resp = super(Session, self).request(method, path, **kwargs)
        return self._response(resp)

    @staticmethod
    def _response(response):
        if not response.content:
            return None
        data = response.json()
        if Session._is_error(data):
            raise PartnerError(data['error'], response, data)
        return data

    @staticmethod
    def _is_error(data):
        return len(data) == 2 and all(x in data for x in ('code', 'error'))
