# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.avia_booking_log_collector import AviaPartnerBookingLogCollector
from travel.cpa.lib.order_snapshot import (
    GogateAviaOrderSnapshot, SupersaverAviaOrderSnapshot, TripruAviaOrderSnapshot, TripcomAviaOrderSnapshot,
    OrderCurrencyCode,
)


class GogateCollector(AviaPartnerBookingLogCollector):
    PARTNER_NAME = 'gogate'
    SNAPSHOT_CLS = GogateAviaOrderSnapshot

    def __init__(self, options):
        super(GogateCollector, self).__init__(options=options, partner_name=self.PARTNER_NAME)


class SupersaverCollector(AviaPartnerBookingLogCollector):
    PARTNER_NAME = 'supersaver'
    SNAPSHOT_CLS = SupersaverAviaOrderSnapshot

    def __init__(self, options):
        super(SupersaverCollector, self).__init__(options=options, partner_name=self.PARTNER_NAME)


class TripruCollector(AviaPartnerBookingLogCollector):
    PARTNER_NAME = 'trip_ru'
    SNAPSHOT_CLS = TripruAviaOrderSnapshot

    def __init__(self, options):
        super(TripruCollector, self).__init__(options=options, partner_name=self.PARTNER_NAME)


class TripcomCollector(AviaPartnerBookingLogCollector):
    PARTNER_NAME = 'tripcom'
    SNAPSHOT_CLS = TripcomAviaOrderSnapshot
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.CNY.value

    def __init__(self, options):
        super(TripcomCollector, self).__init__(options=options, partner_name=self.PARTNER_NAME)
