# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.lib_logging import get_logger
from travel.cpa.lib.order_snapshot import AviakassaAviaOrderSnapshot, OrderStatus

LOG = get_logger(__name__)


class AviakassaCollector(YandexAviaCollector):
    PARTNER_NAME = 'aviakassa'
    PARTNER_CODE = 'aviakass'

    BASE_URL = 'https://meta.aviakassa.com/v4/meta/avia/a/stat'

    SNAPSHOT_CLS = AviakassaAviaOrderSnapshot
    BOOKINGS_PATH = '//bookings/booking'

    STATUS_MAPPING = dict(
        YandexAviaCollector.STATUS_MAPPING,
        PARTIALLYPAID=OrderStatus.PENDING,
        REFUNDED=OrderStatus.CANCELLED,
        PARTIALLYCANCELLED=OrderStatus.CANCELLED,
    )

    def __init__(self, options):
        super(AviakassaCollector, self).__init__(options)

        self.params = {'password': options.password}

    @classmethod
    def configure(cls, parser):
        super(AviakassaCollector, cls).configure(parser)

        parser.add_argument('--base-url', default=cls.BASE_URL)

        parser.add_argument('--password', required=True)

    def get_order_snapshot(self, raw_snapshot):
        snapshot = super(AviakassaCollector, self).get_order_snapshot(raw_snapshot)
        if snapshot is None:
            return None
        # В качестве уникального идентификатора используем PNR+created_at.
        # Из родительского класса нам приходит снэпшот, в котором partner_order_id - это PNR.
        snapshot.update_partner_order_id(
            '{}_{}'.format(snapshot.partner_order_id, snapshot.created_at),
        )
        return snapshot
