# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.order_snapshot import AviaoperatorAviaOrderSnapshot


class AviaoperatorCollector(YandexAviaCollector):
    PARTNER_NAME = 'aviaoperator'
    PARTNER_CODE = 'aviaoperator'

    BASE_URL = 'http://api.aviaoperator.com/api/getstatistics'

    SNAPSHOT_CLS = AviaoperatorAviaOrderSnapshot
    BOOKINGS_PATH = '//bookings/booking'
    FILL_AIRPORTS = True
    DROP_STATUS = None

    def __init__(self, options):
        super(AviaoperatorCollector, self).__init__(options)

        self.auth = None
        self.params = dict(
            password=options.password,
        )

    @classmethod
    def configure(cls, parser):
        YandexAviaCollector.configure(parser)
        parser.add_argument('--password')
        parser.add_argument('--base-url', default=cls.BASE_URL)
