# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.order_snapshot import BiletinetAviaOrderSnapshot


class BiletinetCollector(YandexAviaCollector):
    # Он же Вэртас Vertas
    PARTNER_NAME = 'biletinet'
    PARTNER_CODE = 'biletinet'

    BASE_URL = 'http://bilet-inet.ru/index.php?go=settings/download_metasearch_stat'

    SNAPSHOT_CLS = BiletinetAviaOrderSnapshot
    BOOKINGS_PATH = '//bookings/booking'
    FILL_AIRPORTS = True

    def __init__(self, options):
        super(BiletinetCollector, self).__init__(options)

        self.params = {
            'partner': options.login,
            'password': options.password,
        }

    @classmethod
    def configure(cls, parser):
        YandexAviaCollector.configure(parser)
        parser.add_argument('--login')
        parser.add_argument('--password')

        parser.add_argument('--base-url', default=cls.BASE_URL)
