# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.lib_logging import get_logger
from travel.cpa.lib.order_snapshot import CitytravelAviaOrderSnapshot, Citytravel1AviaOrderSnapshot

LOG = get_logger(__name__)


class CitytravelCollector(YandexAviaCollector):
    PARTNER_NAME = 'citytravel'
    PARTNER_CODE = 'citytravel'

    BASE_URL = 'http://avia.city.travel/aviasales/statistics'

    SNAPSHOT_CLS = CitytravelAviaOrderSnapshot
    BOOKINGS_PATH = '//bookings/booking'
    FILL_AIRPORTS = False

    def __init__(self, options):
        super(CitytravelCollector, self).__init__(options)

        self.params = {
            'partner': options.login,
            'password': options.password,
        }

    @classmethod
    def configure(cls, parser):
        super(CitytravelCollector, cls).configure(parser)

        parser.add_argument('--base-url', default=cls.BASE_URL)

        parser.add_argument('--login', required=True)
        parser.add_argument('--password', required=True)


class Citytravel1Collector(CitytravelCollector):
    PARTNER_NAME = 'citytravel1'
    PARTNER_CODE = 'citytravel1'

    SNAPSHOT_CLS = Citytravel1AviaOrderSnapshot
