# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.avia_booking_log_collector import AviaPartnerBookingLogHistoryCollector
from travel.cpa.lib.order_snapshot import (
    AeroflotAviaOrderSnapshot, AgentAviaOrderSnapshot, AviakassaAviaOrderSnapshot, AviaoperatorAviaOrderSnapshot,
    AzimuthAviaOrderSnapshot, BiletdvAviaOrderSnapshot, BiletikaeroagAviaOrderSnapshot, BiletinetAviaOrderSnapshot,
    BiletixAviaOrderSnapshot, BookandtripAviaOrderSnapshot, CitytravelAviaOrderSnapshot, ClickaviaAviaOrderSnapshot,
    ExpressaviaAviaOrderSnapshot, KupibiletAviaOrderSnapshot, MegotravelAviaOrderSnapshot, NebotravelAviaOrderSnapshot,
    OrderCurrencyCode, OzonAviaOrderSnapshot, PobedaAviaOrderSnapshot, RuslineAviaOrderSnapshot,
    SuperkassaAviaOrderSnapshot, SvyaznoyAviaOrderSnapshot, TicketsruAviaOrderSnapshot, TinkoffAviaOrderSnapshot,
    TutuAviaOrderSnapshot, UzairwaysAviaOrderSnapshot, UtairAviaOrderSnapshot, TripcomHistoryAviaOrderSnapshot,
)


class AviakassaHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'aviakassa_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'aviakassa'
    PARTNER_NAME_IN_LOG = 'aviakass'
    SNAPSHOT_CLS = AviakassaAviaOrderSnapshot

    def __init__(self, options):
        super(AviakassaHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME,
                                                        partner_name_in_log=self.PARTNER_NAME_IN_LOG)


class AviaoperatorHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'aviaoperator_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'aviaoperator'
    SNAPSHOT_CLS = AviaoperatorAviaOrderSnapshot

    def __init__(self, options):
        super(AviaoperatorHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class AzimuthHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'azimuth_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'azimuth'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = AzimuthAviaOrderSnapshot

    def __init__(self, options):
        super(AzimuthHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class BiletikaeroagHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'biletikaeroag_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'biletikaeroag'
    SNAPSHOT_CLS = BiletikaeroagAviaOrderSnapshot

    def __init__(self, options):
        super(BiletikaeroagHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class BiletinetHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'biletinet_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'biletinet'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = BiletinetAviaOrderSnapshot

    def __init__(self, options):
        super(BiletinetHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class BiletixHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'biletix_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'biletix'
    SNAPSHOT_CLS = BiletixAviaOrderSnapshot

    def __init__(self, options):
        super(BiletixHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class BooktripruagHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'booktripruag_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'booktripruag'
    SNAPSHOT_CLS = BookandtripAviaOrderSnapshot

    def __init__(self, options):
        super(BooktripruagHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class CitytravelHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'citytravel_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'citytravel'
    SNAPSHOT_CLS = CitytravelAviaOrderSnapshot

    def __init__(self, options):
        super(CitytravelHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class ClickaviaHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'clickavia_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'clickavia'
    PARTNER_NAME_IN_LOG = 'clickaviatravelab'
    SNAPSHOT_CLS = ClickaviaAviaOrderSnapshot

    def __init__(self, options):
        super(ClickaviaHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME,
                                                        partner_name_in_log=self.PARTNER_NAME_IN_LOG)


class KupibiletHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'kupibilet_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'kupibilet'
    SNAPSHOT_CLS = KupibiletAviaOrderSnapshot

    def __init__(self, options):
        super(KupibiletHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class MegotravelHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'megotravel_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'megotravel'
    SNAPSHOT_CLS = MegotravelAviaOrderSnapshot

    def __init__(self, options):
        super(MegotravelHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class NebotravelHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'nebotravel_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'nebotravel'
    SNAPSHOT_CLS = NebotravelAviaOrderSnapshot

    def __init__(self, options):
        super(NebotravelHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class RuslineHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'rusline_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'rusline'
    SNAPSHOT_CLS = RuslineAviaOrderSnapshot

    def __init__(self, options):
        super(RuslineHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class TinkoffHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'tinkoff_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'tinkoff'
    PARTNER_NAME_IN_LOG = 'tinkoff1'
    SNAPSHOT_CLS = TinkoffAviaOrderSnapshot

    def __init__(self, options):
        super(TinkoffHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME,
                                                      partner_name_in_log=self.PARTNER_NAME_IN_LOG)


class TutuHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'tutu_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'tutu'
    PARTNER_NAME_IN_LOG = 'tutu'
    SNAPSHOT_CLS = TutuAviaOrderSnapshot

    def __init__(self, options):
        super(TutuHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME,
                                                   partner_name_in_log=self.PARTNER_NAME_IN_LOG)


class AgentHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'agent_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'agent'
    SNAPSHOT_CLS = AgentAviaOrderSnapshot

    def __init__(self, options):
        super(AgentHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class ExpressaviaHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'expressavia_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'expressavia'
    SNAPSHOT_CLS = ExpressaviaAviaOrderSnapshot

    def __init__(self, options):
        super(ExpressaviaHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class UzairwaysHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'uzairways_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'uzairways'
    SNAPSHOT_CLS = UzairwaysAviaOrderSnapshot

    def __init__(self, options):
        super(UzairwaysHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class UtairHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'utair_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'utair'
    SNAPSHOT_CLS = UtairAviaOrderSnapshot

    def __init__(self, options):
        super(UtairHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class SuperkassaHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'superkassa_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'superkassa'
    SNAPSHOT_CLS = SuperkassaAviaOrderSnapshot

    def __init__(self, options):
        super(SuperkassaHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class SvyaznoyHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'svyaznoy_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'svyaznoy'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = SvyaznoyAviaOrderSnapshot

    def __init__(self, options):
        super(SvyaznoyHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class PobedaHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'pobeda_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'pobeda'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = PobedaAviaOrderSnapshot

    def __init__(self, options):
        super(PobedaHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class BiletdvHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'biletdv_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'biletdv'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = BiletdvAviaOrderSnapshot

    def __init__(self, options):
        super(BiletdvHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class TicketsruHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'ticketsru_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'ticketsru'
    SNAPSHOT_CLS = TicketsruAviaOrderSnapshot

    def __init__(self, options):
        super(TicketsruHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class AeroflotHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'aeroflot_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'aeroflot'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = AeroflotAviaOrderSnapshot

    def __init__(self, options):
        super(AeroflotHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)

    def row_to_snapshot(self, row):
        if not row['price']:
            row['price'] = 0
        return super(AeroflotHistoryCollector, self).row_to_snapshot(row)


class OzonHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'ozon_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'ozon'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.RUB.value
    SNAPSHOT_CLS = OzonAviaOrderSnapshot

    def __init__(self, options):
        super(OzonHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)


class TripcomHistoryCollector(AviaPartnerBookingLogHistoryCollector):
    PARTNER_NAME = 'tripcom_history'  # партнер для запуска из командной строки
    REAL_PARTNER_NAME = 'tripcom'
    CURRENCY_INSTEAD_OF_NONE = OrderCurrencyCode.CNY.value
    SNAPSHOT_CLS = TripcomHistoryAviaOrderSnapshot

    def __init__(self, options):
        super(TripcomHistoryCollector, self).__init__(options, partner_name=self.REAL_PARTNER_NAME)
