# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from copy import copy
from datetime import timedelta

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.lib_logging import get_logger
from travel.cpa.lib.order_snapshot import MegotravelAviaOrderSnapshot

LOG = get_logger(__name__)


class MegotravelCollector(YandexAviaCollector):
    PARTNER_NAME = 'megotravel'
    PARTNER_CODE = 'megotravel'

    BASE_URL = 'http://api.go2see.ru/api/MetaSearch/Statistics'

    SNAPSHOT_CLS = MegotravelAviaOrderSnapshot
    BOOKINGS_PATH = '//bookings/booking'

    FILL_AIRPORTS = True
    FLIGHT_NODE_XPATH = 'Segment/Segment/flight'

    def __init__(self, options):
        super(MegotravelCollector, self).__init__(options)

        self.params = {
            'partner': options.login,
            'password': options.password,
        }

    @classmethod
    def configure(cls, parser):
        YandexAviaCollector.configure(parser)

        parser.add_argument('--login')
        parser.add_argument('--password')

        parser.add_argument('--base-url', default=cls.BASE_URL)

    def get_day_report_once(self, day_date):
        params = copy(self.params)
        params.update({
            'date1': day_date.strftime('%Y-%m-%d'),
            'date2': (day_date + timedelta(days=1)).strftime('%Y-%m-%d'),
        })
        rsp = self.request_get(
            self.base_url,
            params=params,
            auth=self.auth,
            timeout=self.REQUEST_TIMEOUT
        )
        return rsp.content
