# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.yandex_avia_collector import YandexAviaCollector
from travel.cpa.lib.lib_logging import get_logger
from travel.cpa.lib.order_snapshot import SuperkassaAviaOrderSnapshot

LOG = get_logger(__name__)


class SuperkassaCollector(YandexAviaCollector):
    PARTNER_NAME = 'superkassa'
    PARTNER_CODE = 'superkassa'

    BASE_URL = 'https://superkassa.net/api/partner/statistics.php'

    SNAPSHOT_CLS = SuperkassaAviaOrderSnapshot
    BOOKINGS_PATH = '//booking'
    DROP_STATUS = 'REFUND'

    def __init__(self, options):
        super(SuperkassaCollector, self).__init__(options)

        self.auth = (options.user, options.password)
        self.params = {'hash': options.hash}

    @classmethod
    def configure(cls, parser):
        super(SuperkassaCollector, cls).configure(parser)

        parser.add_argument('--base-url', default=cls.BASE_URL)

        parser.add_argument('--user', default='yandex')
        parser.add_argument('--password', required=True)
        parser.add_argument('--hash', required=True)
