# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.buses.common import BusesCollector
from travel.cpa.lib.order_snapshot import BusforBusesOrderSnapshot


class BusforBusesCollector(BusesCollector):
    PARTNER_NAME = 'busfor'
    SNAPSHOT_CLS = BusforBusesOrderSnapshot

    DISPOSITIONS = [
        1,  # the fee is located inside the tariff
        2,  # the fee is located above the tariff
    ]
    COMMISSION_TYPES = [
        3,  # agent fee №2
        6,  # service charge
    ]

    def _calc_order_billing(self, raw_order, order):
        super(BusforBusesCollector, self)._calc_order_billing(raw_order, order)
        tickets = raw_order['booking'].get('tickets', [])
        if tickets:
            partner_fee = 0.0
            order['partner_commission'] = 0.0
            for ticket in tickets:
                cpa_payload = ticket.get('cpaPayload')
                if not cpa_payload:
                    continue
                commissions = cpa_payload.get('commissions')
                if not commissions:
                    continue

                for commission in commissions:
                    commission_type = commission.get('type')
                    disposition = commission.get('disposition')
                    if commission_type in self.COMMISSION_TYPES and disposition in self.DISPOSITIONS:
                        partner_fee += commission.get('value', 0)
            if partner_fee:
                order['partner_commission'] = round(partner_fee * 0.01, 2)
