# -*- coding: utf-8 -*-
from __future__ import unicode_literals

import yaml

from collections import OrderedDict

from library.python import resource


class BusesRates(object):
    BUS_FEES_CFG = 'rates.yaml'

    def __init__(self):
        self.bus_billing = yaml.safe_load(resource.find(self.BUS_FEES_CFG))
        if self.bus_billing is None:
            raise ValueError("error getting buses billing, unexpected None value")

    def get_order_agency_rate(self, partner_name, order_date):
        billing = self.bus_billing['partners'][partner_name]
        return self._get_agency_rate(billing, order_date)

    @staticmethod
    def _get_agency_rate(billing, order_date):
        revenue = billing['rates']['revenue'] * 0.01
        history = billing.get('history')
        if history is None:
            return revenue
        revenue_history = history.get('revenue')
        if revenue_history is None:
            return revenue
        sorted_history = OrderedDict(sorted(revenue_history.items()))

        for switch_date, old_revenue in sorted_history.items():
            if order_date < switch_date:
                return old_revenue * 0.01
        return revenue
