# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from travel.cpa.collectors.lib.boy_hotel_collector import BoYHotelCollector
from travel.cpa.lib.lib_logging import get_logger
from travel.cpa.lib.order_snapshot import ExpediaOrderSnapshot

LOG = get_logger(__name__)


class ExpediaCollector(BoYHotelCollector):
    PARTNER_NAME = 'expedia'
    ORDER_TYPE = 'HOTEL_EXPEDIA'
    ALLOW_PROXY = False

    def init_hotel_snapshot(self, raw_snapshot):
        snapshot = ExpediaOrderSnapshot()
        snapshot.itinerary_id = raw_snapshot['itinerary_id']
        snapshot.confirmation_id = raw_snapshot['confirmation_id']
        return snapshot
