# -*- coding: utf-8 -*-
from __future__ import unicode_literals

from abc import ABCMeta, abstractmethod
from collections import Counter
from datetime import datetime

import requests

from travel.cpa.lib.errors import ErrorType, ProcessError
from travel.cpa.lib.lib_datetime import timestamp
from travel.cpa.lib.lib_logging import get_logger


LOG = get_logger(__name__)


class Collector(object):
    __metaclass__ = ABCMeta
    PARTNER_NAME = None

    def __init__(self):
        self.now = datetime.utcnow()
        self.metrics = Counter(**{
            'collector.events.http_retry': 0,
            'collector.events.invalid_response': 0,
            'collector.stats.processing_time': 0,
            'collector.snapshots.count': 0,
            'collector.stats.total_response_bytes': 0,
        })

    @classmethod
    def configure_all(cls, parser):
        pass

    @classmethod
    @abstractmethod
    def configure(cls, parser):
        pass

    @abstractmethod
    def _get_snapshots(self):
        pass

    def get_snapshots(self):
        try:
            for snapshot in self._get_snapshots():
                self.metrics['collector.snapshots.count'] += 1
                snapshot.updated_at = timestamp(datetime.utcnow())
                yield snapshot
        except requests.exceptions.RequestException:
            LOG.exception('Partner error')
            raise ProcessError(ErrorType.ET_PARTNER_CONNECTION)
