# -*- coding: utf-8 -*-

from argparse import ArgumentParser
import logging.config
import sys

from travel.cpa.data_check.reconciliation.email_client import EmailClient
from travel.cpa.data_check.reconciliation.log_config import LOG_CONFIG
from travel.cpa.data_check.reconciliation.partner import PARTNERS
from travel.cpa.data_check.reconciliation.st_client import StClient
from travel.library.python.tools import replace_args_from_env


LOG = logging.getLogger(__name__)


def main():
    logging.config.dictConfig(LOG_CONFIG)
    LOG.info('Process started')

    parser = ArgumentParser()

    default_orders_table = '//home/travel/prod/cpa/hotels/orders'
    parser.add_argument('--orders-table', default=default_orders_table)

    parser.add_argument('--st-token', required=True)
    parser.add_argument('--related-issue', default='HOTELS-3927')
    parser.add_argument('--assignee', default='alittleprince')

    parser.add_argument('--login', default='robot-travel-test@yandex-team.ru')
    parser.add_argument('--imap-token', required=True)

    parser.add_argument('--yt-token', required=True)

    parser.add_argument('--debug-mode', action='store_true')
    parser.add_argument('--partner', default=None)

    parser.add_argument('--stocks-url', default='http://stocks.yandex.net/xmlhist')

    options = parser.parse_args(replace_args_from_env(sys.argv[1:]))

    st_client = StClient(options.st_token, options.debug_mode)
    with EmailClient(options.login, options.imap_token, options.debug_mode) as email_client:
        for partner_cls in PARTNERS:
            if options.partner and options.partner != partner_cls.__partner_name__:
                LOG.info('Skipping partner %s', partner_cls.__partner_name__)
                continue
            partner = partner_cls(email_client, st_client, options)
            partner.process()


if __name__ == '__main__':
    main()
