# -*- coding: utf-8 -*-

from parse import compile
from datetime import date
from typing import NamedTuple

from dateutil.relativedelta import relativedelta


DATETIME_PATTERN_EMAIL = compile('{:te}')
DATETIME_PATTERN_ISO = compile('{:ti}')


def parse_date_iso(dt_text):
    match = DATETIME_PATTERN_ISO.parse(dt_text)
    return match[0].date()


def parse_datetime_email(data):
    match = DATETIME_PATTERN_EMAIL.parse(data)
    if match:
        return match[0]


class DateRange(NamedTuple):
    from_date: date
    to_date: date

    def is_full_month(self):
        return get_month_range(self.from_date) == self


def get_month_range(d: date) -> DateRange:
    from_date = d.replace(day=1)
    to_date = from_date + relativedelta(months=+1, days=-1)
    return DateRange(from_date=from_date, to_date=to_date)
