# -*- coding: utf-8 -*-

from typing import List, NamedTuple

from travel.cpa.data_check.reconciliation.datetime_tools import DateRange


class OrderDiff(NamedTuple):
    order_id: str
    order_amount_diff: str
    profit_amount_diff: str
    fail_reason: str


class ReportDiff(NamedTuple):
    report_dates: DateRange
    partner_extra_orders: List[str]
    cpa_extra_orders: List[str]
    differed_orders: List[OrderDiff]
