package ru.yandex.travel.cpa.data_processing.flow.logbroker;

import java.util.List;
import java.util.function.Consumer;

import lombok.Data;

@Data
public class LogbrokerDataBatch {
    private final List<Long> cookies;
    private final List<LogbrokerMessage> messages;
    private final Consumer<LogbrokerDataBatch> committer;
    private final String cluster;

    public static LogbrokerDataBatch emptyBatch() {
        return new LogbrokerDataBatch(null, null, null, null);
    }

    public boolean isEmpty() {
        return messages == null;
    }

    public void commit() throws Exception {
        this.committer.accept(this);
    }
}
