package ru.yandex.travel.cpa.data_processing.flow.model;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public abstract class AbstractMessageDecoder<T> implements MessageDecoder<T> {

    @Override
    public List<T> decode(byte[] data) throws IOException {
        var messages = new ArrayList<T>();
        for (var line : new String(data, StandardCharsets.UTF_8).split("\n")) {
            if (line.equals("")) {
                continue;
            }
            // Dirty hack for skip broken avia labels. Dorp it asap
            if (!line.startsWith("{")) {
                continue;
            }
            // End of hack
            T message = decodeItem(line);
            if (message == null) {
                throw new RuntimeException(String.format("Failed to convert object '%s'", line));
            }
            messages.add(message);
        }
        return messages;
    }

    protected abstract T decodeItem(String data) throws IOException;
}
