package ru.yandex.travel.cpa.data_processing.flow.model.labels;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.travel.cpa.data_processing.flow.yt.YtMessageConverter;
import ru.yandex.yt.ytclient.tables.ColumnValueType;
import ru.yandex.yt.ytclient.tables.TableSchema;
import ru.yandex.yt.ytclient.wire.UnversionedValue;

public class LabelConverter implements YtMessageConverter<LabelKey, Label> {
    private final static int CATEGORY_COL = 0;
    private final static int LABEL_COL = 1;
    private final static int DATA_COL = 2;

    @Override
    public TableSchema getTableSchema() {
        return new TableSchema.Builder()
                .addKey("category", ColumnValueType.STRING)
                .addKey("label", ColumnValueType.STRING)
                .addValue("data", ColumnValueType.STRING)
                .build();
    }

    @Override
    public Map<String, Serializable> serialize(Label object) {
        var serialized = new HashMap<String, Serializable>();
        serialized.put("category", object.getCategory());
        serialized.put("label", object.getLabel());
        serialized.put("data", object.getData());
        return serialized;
    }

    // column order should match one at getLookupColumns
    @Override
    public Label deserialize(List<UnversionedValue> row) {
        return new Label(
                row.get(CATEGORY_COL).stringValue(),
                0,
                row.get(LABEL_COL).stringValue(),
                row.get(DATA_COL).bytesValue()
        );
    }

    // column order should match one at deserialize
    @Override
    public List<String> getLookupColumns() {
        return List.of("category", "label", "data");
    }

    @Override
    public List<Object> getFilterValues(Label message) {
        return List.of(message.getCategory(), message.getLabel());
    }

    @Override
    public List<String> getSelectColumns() {
        return List.of("category", "label");
    }

    @Override
    public String getSelectValues(LabelKey key) {
        return String.format("('%s', '%s')", key.getCategory(), key.getLabel());
    }
}
